'''
Demonstrates combining the mesh of two scene nodes
'''
from PySide2.QtWidgets import QWidget, QVBoxLayout, QPushButton, QLabel, QDialog, QMessageBox
from pymxs import runtime as rt
import MaxPlus

def get_object_mesh(node):
    """
    Get the object mesh from the provided node
    """
    node.Convert(MaxPlus.ClassIds.TriMeshGeometry)
    object_state = node.EvalWorldState()
    obj_original = object_state.Getobj()
    tri_obj = MaxPlus.TriObject._CastFrom(obj_original)
    tri_mesh = tri_obj.GetMesh()
    return tri_mesh

def combine_two_meshes():
    """
    Convert the two provided objects to meshes and merge them as a single editable mesh.
    """
    if MaxPlus.SelectionManager.GetCount() != 2 :
        msg = "Please select 2 nodes to combine."
        print(msg)
        show_alert(msg)
    else:
        node1 = MaxPlus.SelectionManager.GetNode(0)
        node2 = MaxPlus.SelectionManager.GetNode(1)
        a = get_object_mesh(node1)
        b = get_object_mesh(node2)
        # create a new, empty mesh for the combined meshes:
        new_obj = MaxPlus.Factory.CreateNewTriObject()
        new_node = MaxPlus.Factory.CreateNode(new_obj)
        new_mesh = new_obj.GetMesh()
        # combine a and b into the new mesh:
        MaxPlus.Mesh.CombineMeshes(new_mesh,a,b)

def show_alert(message):
    """
    Display a message using a Qt Message Box.
    """
    msg_box = QMessageBox()
    msg_box.setText(message)
    msg_box.exec_()

def demo_combine_meshes():
    """
    Demonstrates combining the mesh of two scene nodes
    Prompt user to select two nodes to be merged and merge them.
    """
    dialog = QDialog(QWidget.find(rt.windows.getMAXHWND()))
    dialog.resize(250, 100)
    dialog.setWindowTitle('DEMO - Combine 2 Nodes')

    main_layout = QVBoxLayout()
    label = QLabel("Combine 2 Nodes")
    main_layout.addWidget(label)

    combine_btn = QPushButton("Combine")
    combine_btn.clicked.connect(combine_two_meshes)
    main_layout.addWidget(combine_btn)

    dialog.setLayout(main_layout)
    dialog.show()

demo_combine_meshes()
